# Sunset Lagoons - Luxury Pool Cost Calculator Price Sheet

This document contains all pricing data used in the Sunset Lagoons pool cost calculator. These values determine the estimated costs presented to customers when using the calculator.

## Pool Types & Base Pricing

| Pool Type | Base Price | Multiplier Factor |
|-----------|------------|-------------------|
| Infinity Edge Pool | $25,000 | 1.4 |
| Natural Lagoon Pool | $30,000 | 1.5 |
| Modern Geometric Pool | $20,000 | 1.2 |
| Lap Pool | $18,000 | 1.1 |
| Plunge Pool | $15,000 | 1.0 |
| Pool & Spa Combination | $35,000 | 1.6 |

## Pool Size Options

| Size Category | Base Price | Multiplier Factor | Square Footage |
|---------------|------------|-------------------|----------------|
| Small (up to 300 sq ft) | $15,000 | 1.0 | 300 |
| Medium (300-600 sq ft) | $25,000 | 1.5 | 450 |
| Large (600-800 sq ft) | $35,000 | 2.0 | 700 |
| Extra Large (800+ sq ft) | $45,000 | 2.5 | 900 |

## Pool Depth Options

| Depth Profile | Multiplier Factor |
|---------------|-------------------|
| Shallow (3-5 ft uniform) | 0.8 |
| Standard (3-6 ft graduated) | 1.0 |
| Diving (3-8 ft graduated) | 1.3 |
| Custom Depth Profile | 1.5 |

## Terrain Types

| Terrain Type | Multiplier Factor |
|--------------|-------------------|
| Flat | 1.0 |
| Sloped | 1.3 |
| Rocky | 1.5 |
| Clay Soil | 1.2 |
| Sandy Soil | 1.1 |

## Surface Materials

| Surface Type | Cost per Square Foot |
|--------------|----------------------|
| Standard Plaster | $5 |
| Quartz Aggregate | $10 |
| Pebble Finish | $15 |
| Glass Bead Finish | $20 |
| Full Tile | $40 |

## Deck Materials

| Deck Material | Cost per Square Foot |
|---------------|----------------------|
| Stamped Concrete | $15 |
| Pavers | $20 |
| Natural Stone | $35 |
| Travertine | $30 |
| Composite Decking | $25 |

## Coping Materials

| Coping Material | Cost per Linear Foot |
|-----------------|----------------------|
| Poured Concrete | $25 |
| Brick | $35 |
| Limestone | $45 |
| Travertine | $50 |
| Granite | $65 |

## Water Features

| Feature | Cost |
|---------|------|
| Waterfall | $5,000 |
| Fountain Jets | $3,000 |
| Scuppers | $2,500 |
| Bubblers | $1,500 |
| Laminar Jets | $4,000 |
| Rain Wall | $7,500 |

## Fire Features

| Feature | Cost |
|---------|------|
| Fire Pit | $3,500 |
| Fire Bowls | $5,000 |
| Fire Wall | $8,000 |
| Outdoor Fireplace | $12,000 |

## Recreational Features

| Feature | Cost |
|---------|------|
| Water Slide | $5,000 |
| Diving Board | $2,500 |
| Rock Feature | $7,500 |
| Beach Entry | $8,000 |
| Swim-up Bar | $10,000 |
| Tanning Ledge | $4,000 |

## Lighting & Sound Systems

| Feature | Cost |
|---------|------|
| LED Pool Lights | $3,000 |
| Fiber Optic Lighting | $5,000 |
| Color-Changing System | $4,000 |
| Landscape Lighting | $5,000 |
| Underwater Speakers | $3,500 |
| Outdoor Sound System | $6,000 |

## Sanitation Systems

| System Type | Cost |
|-------------|------|
| Traditional Chlorine | $1,500 |
| Salt Water Chlorinator | $3,000 |
| UV Sanitization | $4,500 |
| Ozone System | $5,000 |
| Advanced Oxidation Process | $7,500 |
| Mineral System | $3,500 |

## Heating Systems

| System Type | Cost |
|-------------|------|
| No Heating | $0 |
| Gas Heater | $4,000 |
| Heat Pump | $6,000 |
| Solar Heating | $8,000 |
| Hybrid System | $10,000 |

## Pool Covers

| Cover Type | Cost |
|------------|------|
| No Cover | $0 |
| Manual Safety Cover | $3,000 |
| Automatic Cover | $12,000 |
| Hidden/Recessed Cover | $15,000 |
| Solar Blanket | $1,500 |

## Automation & Smart Features

| Feature | Cost |
|---------|------|
| Smart Control System | $5,000 |
| Smartphone App Control | $2,000 |
| Voice Control Integration | $1,500 |
| Automated Chemical Management | $3,500 |
| Auto-Fill System | $1,000 |
| Robotic Cleaner | $2,500 |

## Outdoor Living Features

| Feature | Cost |
|---------|------|
| Outdoor Kitchen | $15,000 |
| Pergola/Shade Structure | $8,000 |
| Outdoor Shower | $3,500 |
| Pool House/Cabana | $25,000 |
| Premium Outdoor Furniture | $10,000 |

## Fencing Options

| Fencing Type | Cost |
|--------------|------|
| No New Fencing (Existing) | $0 |
| Aluminum/Metal Fencing | $5,000 |
| Glass Panel Fencing | $15,000 |
| Vinyl Fencing | $4,000 |
| Wood Fencing | $6,000 |
| Stone/Masonry Wall | $12,000 |

## Landscaping Packages

| Package | Cost |
|---------|------|
| No Landscaping | $0 |
| Basic Package | $5,000 |
| Premium Package | $12,000 |
| Luxury Package | $25,000 |
| Custom Design | $35,000 |

## Project Timeline Estimates

### Design Phase
- Base: 2 weeks
- Custom design additional time: 1 week

### Permits Phase
- Base: 2 weeks
- Complex projects additional time: 2 weeks

### Excavation Phase (in weeks)
- Small pool: 1 week
- Medium pool: 1.5 weeks
- Large pool: 2 weeks
- Extra Large pool: 2.5 weeks

### Terrain Adjustments (additional weeks)
- Flat: 0
- Sloped: 0.5
- Rocky: 1
- Clay: 0.5
- Sandy: 0

### Construction Phase (in weeks)
- Small pool: 3 weeks
- Medium pool: 4 weeks
- Large pool: 5 weeks
- Extra Large pool: 6 weeks

### Pool Type Adjustments (additional weeks)
- Infinity Edge: +1 week
- Natural Lagoon: +1.5 weeks
- Modern Geometric: +0.5 weeks
- Lap Pool: 0
- Plunge Pool: -0.5 weeks
- Pool & Spa Combination: +1 week

### Finishing Phase
- Base: 2 weeks
- Full tile additional time: 1 week
- Per feature additional time: 0.1 weeks

## Equipment Needs

### Basic Equipment (Small Pools)
- Excavator (10-ton)
- Bobcat/Skid Steer Loader
- Dump Truck
- Concrete Pump
- Compactor

### Medium Equipment (Medium Pools)
- Excavator (20-ton)
- Bobcat/Skid Steer Loader
- Dump Truck
- Concrete Pump
- Compactor
- Trencher

### Large Equipment (Large/XL Pools)
- Excavator (30-ton)
- Bobcat/Skid Steer Loader
- Dump Truck (Multiple)
- Concrete Pump
- Compactor
- Trencher
- Shotcrete Equipment

### Specialty Equipment
- Infinity Edge Pools: Specialized Forming Equipment, Additional Concrete Pump
- Natural Lagoon Pools: Rock Placement Equipment, Specialized Landscaping Tools
- Rocky Terrain: Rock Hammer/Breaker, Additional Excavator

## Cost Calculation Formulas

1. Base Pool Cost = Pool Type Base Price × Pool Size Factor

2. Excavation Cost = Base Pool Cost × 0.2 × Terrain Factor

3. Shell Construction Cost = Base Pool Cost × 0.4 × Depth Factor

4. Plumbing and Electrical Cost = Base Pool Cost × 0.15

5. Finishes Cost = Pool Square Footage × Surface Material Cost per Square Foot

6. Coping Cost = Pool Perimeter × Coping Material Cost per Linear Foot
   - Pool Perimeter is estimated as: Square Root of Square Footage × 4

7. Deck Cost = Deck Area × Deck Material Cost per Square Foot
   - Deck Area is estimated as: Pool Square Footage × 1.5

8. Equipment Rental Cost = Base Pool Cost × 0.1

9. Total Cost = Sum of all individual costs (construction, features, technology, landscaping, equipment)

10. Total Project Timeline = Sum of all phase durations (design, permits, excavation, construction, finishing)
    - Maximum timeline adds 30% buffer to minimum timeline
