# Sunset Lagoons Market Research - Boise Area Luxury Pool Market

## Competitor Analysis

### Key Competitors in the Boise Area

1. **Custom Pools Boise**
   - **Pool Types**: Concrete (gunite)
   - **Areas Served**: Idaho, Wyoming, Montana, Oregon, and Nevada
   - **Years in Business**: Over 50 years
   - **Positioning**: Award-winning designs, innovative concepts
   - **Unique Selling Points**: Established reputation, cutting-edge design, full-service capability

2. **Rocky Mountain Pools**
   - **Pool Types**: Concrete (shotcrete)
   - **Areas Served**: Boise and greater Southern Idaho
   - **Years in Business**: Over 50 years (family business)
   - **Positioning**: Family-owned, third-generation pool builder
   - **Unique Selling Points**: Owner-operated (no salesmen), high quality with competitive pricing

3. **Premier Pools & Spas of Boise**
   - **Pool Types**: Gunite/concrete, fiberglass
   - **Areas Served**: Boise area (including Eagle, Meridian, and Star)
   - **Years in Business**: Founders have 12+ years experience
   - **Positioning**: Creating "vibrant outdoor spaces"
   - **Unique Selling Points**: Attention to detail, also offers pool service and equipment repairs

4. **Snake River Pool & Spa**
   - **Pool Types**: Above-ground
   - **Areas Served**: Boise, Meridian, and Twin Falls areas (three branches)
   - **Years in Business**: Over 40 years
   - **Positioning**: Local dealer
   - **Unique Selling Points**: Free in-home consultation, focus on hydrotherapy and wellness

5. **Randall Pool Company**
   - **Pool Types**: Concrete
   - **Areas Served**: Boise metropolitan area (Treasure Valley)
   - **Years in Business**: 15 years (43 years combined experience)
   - **Positioning**: Quality craftsmanship with integrity
   - **Unique Selling Points**: Emphasis on trust and honesty, options for various budgets

6. **H2O Pool Designs**
   - **Pool Types**: Concrete
   - **Areas Served**: Boise/Treasure Valley area
   - **Positioning**: Personal and professional service
   - **Unique Selling Points**: Quality materials, talented craftsmen, projects "unmatched in functionality and aesthetics"

7. **Idaho Pool & Spa**
   - **Pool Types**: Shotcrete/concrete
   - **Areas Served**: Boise metropolitan area + greater Idaho
   - **Years in Business**: Since 1973 (family-owned)
   - **Positioning**: Third-generation pool builder
   - **Unique Selling Points**: Superior quality, outstanding customer service, established reputation

8. **Innovative Rock & Water**
   - **Pool Types**: Concrete
   - **Areas Served**: Boise and greater Idaho
   - **Positioning**: Creating natural environments
   - **Unique Selling Points**: 3D CAD software for visualization, creative design approach

9. **C.H.I. Pools**
   - **Pool Types**: Fiberglass, gunite/concrete
   - **Areas Served**: Greater Boise area
   - **Years in Business**: Over 35 years
   - **Positioning**: Full-service pool company
   - **Unique Selling Points**: 90% business from referrals, demonstration pools at office

10. **River Pools of Boise**
    - **Pool Types**: Fiberglass
    - **Areas Served**: Greater Boise metropolitan area
    - **Years in Business**: 10+ years
    - **Positioning**: Franchise of national brand
    - **Unique Selling Points**: Specialized in fiberglass pools

## Market Pricing Analysis

### Installation Costs by Pool Type

1. **Vinyl Liner Pools**
   - **Price Range**: $60,000 to $75,000
   - **Positioning**: Least expensive type of inground pool
   - **Notes**: Lower upfront cost offset by long-term maintenance expenses

2. **Fiberglass Pools**
   - **Price Range**: $70,000 to $85,000
   - **Average Cost**: Approximately $75,000 for turnkey installation
   - **Notes**: Mid-range pricing with lower long-term maintenance costs

3. **Concrete/Gunite Pools**
   - **Base Price Range**: $75,000 to $100,000
   - **High-End Range**: $100,000 to $200,000+
   - **Positioning**: Most expensive but offers widest customization options
   - **Notes**: High-end customizations can push costs well above $200,000

### Maintenance Costs by Pool Type

1. **Vinyl Liner Pools**
   - **Annual Chemical Costs**: $400
   - **Annual Electricity Costs**: $300
   - **Major Expenses**: Liner replacement every 5-9 years at $4,500 average
   - **10-Year Maintenance Cost**: Approximately $11,500

2. **Concrete Pools**
   - **Major Expenses**: Resurfacing every 10-15 years at $10,000-$20,000
   - **Annual Chemical Costs**: Higher than other pool types due to porous surface
   - **10-Year Maintenance Cost**: Significantly higher than other pool types

3. **Fiberglass Pools**
   - **Annual Maintenance**: Lower chemical and electricity costs
   - **Major Expenses**: Minimal compared to other pool types
   - **10-Year Maintenance Cost**: Lowest of the three pool types

## Market Opportunities and Gaps

1. **Geographic Opportunity**
   - Boise lacks abundant natural water recreation options
   - Summer temperatures often reach mid-90s, creating demand for private pools
   - Serving surrounding areas (Nampa, Meridian, Star, Middleton) expands market reach

2. **Competitive Landscape Gaps**
   - Most established companies focus on concrete/gunite pools
   - Few companies emphasize luxury features and high-end customization
   - Limited focus on eco-friendly and smart technology integration
   - Opportunity to differentiate with premium service and cutting-edge technology

3. **Customer Experience Opportunities**
   - Many companies have been in business for decades but may lack modern customer experience
   - Opportunity for streamlined design process using advanced visualization tools
   - Potential for comprehensive service packages (design, installation, maintenance)

## Market Trends and Customer Preferences

1. **Pool Types and Materials**
   - Concrete pools offer maximum customization but at highest cost
   - Fiberglass pools gaining popularity due to lower maintenance and faster installation
   - Vinyl liner pools remain budget option but require more maintenance

2. **Features and Technology**
   - Smart pool technology integration becoming more important
   - Energy-efficient systems growing in demand
   - Outdoor living spaces integrated with pool design

3. **Service Area Coverage**
   - Most competitors serve Boise metropolitan area/Treasure Valley
   - Some extend to greater Idaho and neighboring states
   - Opportunity to focus on underserved premium neighborhoods

## Conclusion

The Boise luxury pool market presents significant opportunities for Sunset Lagoons to establish itself as a premium brand. With installation costs ranging from $60,000 to over $200,000 depending on pool type and customization, there is substantial revenue potential. The competitive landscape includes several established players, but few appear to focus exclusively on the high-end luxury market with cutting-edge technology and comprehensive service offerings. By positioning as a premium brand with exceptional customer experience and innovative features, Sunset Lagoons can carve out a distinctive niche in this growing market.
